/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset;

import com.jme3.asset.AssetConfig;
import com.jme3.asset.AssetEventListener;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetLocator;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.asset.AssetProcessor;
import com.jme3.asset.CloneableSmartAsset;
import com.jme3.asset.ImplHandler;
import com.jme3.asset.MaterialKey;
import com.jme3.asset.ModelKey;
import com.jme3.asset.TextureKey;
import com.jme3.asset.cache.AssetCache;
import com.jme3.asset.cache.SimpleAssetCache;
import com.jme3.audio.AudioData;
import com.jme3.audio.AudioKey;
import com.jme3.font.BitmapFont;
import com.jme3.material.Material;
import com.jme3.scene.Spatial;
import com.jme3.shader.Shader;
import com.jme3.shader.ShaderKey;
import com.jme3.texture.Texture;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesktopAssetManager
implements AssetManager {
    private static final Logger logger = Logger.getLogger(AssetManager.class.getName());
    private final ImplHandler handler = new ImplHandler(this);
    private CopyOnWriteArrayList<AssetEventListener> eventListeners = new CopyOnWriteArrayList();
    private List<ClassLoader> classLoaders = Collections.synchronizedList(new ArrayList());

    public DesktopAssetManager() {
        this(null);
    }

    @Deprecated
    public DesktopAssetManager(boolean loadDefaults) {
        this(Thread.currentThread().getContextClassLoader().getResource("com/jme3/asset/Desktop.cfg"));
    }

    public DesktopAssetManager(URL configFile) {
        if (configFile != null) {
            this.loadConfigFile(configFile);
        }
        logger.info("DesktopAssetManager created.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigFile(URL configFile) {
        InputStream stream = null;
        try {
            AssetConfig cfg = new AssetConfig(this);
            stream = configFile.openStream();
            cfg.loadText(stream);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Failed to load asset config", ex);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void addClassLoader(ClassLoader loader) {
        this.classLoaders.add(loader);
    }

    @Override
    public void removeClassLoader(ClassLoader loader) {
        this.classLoaders.remove(loader);
    }

    @Override
    public List<ClassLoader> getClassLoaders() {
        return Collections.unmodifiableList(this.classLoaders);
    }

    @Override
    public void addAssetEventListener(AssetEventListener listener) {
        this.eventListeners.add(listener);
    }

    @Override
    public void removeAssetEventListener(AssetEventListener listener) {
        this.eventListeners.remove(listener);
    }

    @Override
    public void clearAssetEventListeners() {
        this.eventListeners.clear();
    }

    @Override
    public void setAssetEventListener(AssetEventListener listener) {
        this.eventListeners.clear();
        this.eventListeners.add(listener);
    }

    @Override
    public void registerLoader(Class<? extends AssetLoader> loader, String ... extensions) {
        this.handler.addLoader(loader, extensions);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Registered loader: {0} for extensions {1}", new Object[]{loader.getSimpleName(), Arrays.toString(extensions)});
        }
    }

    @Override
    public void registerLoader(String clsName, String ... extensions) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(clsName);
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.WARNING, "Failed to find loader: " + clsName, ex);
        }
        catch (NoClassDefFoundError ex) {
            logger.log(Level.WARNING, "Failed to find loader: " + clsName, ex);
        }
        if (clazz != null) {
            this.registerLoader(clazz, extensions);
        }
    }

    @Override
    public void unregisterLoader(Class<? extends AssetLoader> loaderClass) {
        this.handler.removeLoader(loaderClass);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Unregistered loader: {0}", loaderClass.getSimpleName());
        }
    }

    @Override
    public void registerLocator(String rootPath, Class<? extends AssetLocator> locatorClass) {
        this.handler.addLocator(locatorClass, rootPath);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Registered locator: {0}", locatorClass.getSimpleName());
        }
    }

    @Override
    public void registerLocator(String rootPath, String clsName) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(clsName);
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.WARNING, "Failed to find locator: " + clsName, ex);
        }
        catch (NoClassDefFoundError ex) {
            logger.log(Level.WARNING, "Failed to find loader: " + clsName, ex);
        }
        if (clazz != null) {
            this.registerLocator(rootPath, clazz);
        }
    }

    @Override
    public void unregisterLocator(String rootPath, Class<? extends AssetLocator> clazz) {
        this.handler.removeLocator(clazz, rootPath);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Unregistered locator: {0}", clazz.getSimpleName());
        }
    }

    @Override
    public AssetInfo locateAsset(AssetKey<?> key) {
        AssetInfo info = this.handler.tryLocate(key);
        if (info == null) {
            logger.log(Level.WARNING, "Cannot locate resource: {0}", key);
        }
        return info;
    }

    public <T> T getFromCache(AssetKey<T> key) {
        AssetCache cache = this.handler.getCache(key.getCacheType());
        if (cache != null) {
            T asset = cache.getFromCache(key);
            if (asset != null) {
                cache.notifyNoAssetClone();
            }
            return asset;
        }
        throw new IllegalArgumentException("Key " + key + " specifies no cache.");
    }

    public <T> void addToCache(AssetKey<T> key, T asset) {
        AssetCache cache = this.handler.getCache(key.getCacheType());
        if (cache == null) {
            throw new IllegalArgumentException("Key " + key + " specifies no cache.");
        }
        cache.addToCache(key, asset);
        cache.notifyNoAssetClone();
    }

    public <T> boolean deleteFromCache(AssetKey<T> key) {
        AssetCache cache = this.handler.getCache(key.getCacheType());
        if (cache != null) {
            return cache.deleteFromCache(key);
        }
        throw new IllegalArgumentException("Key " + key + " specifies no cache.");
    }

    public void clearCache() {
        this.handler.clearCache();
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "All asset caches cleared.");
        }
    }

    @Override
    public <T> T loadAsset(AssetKey<T> key) {
        Object clone;
        Object obj;
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        for (AssetEventListener listener : this.eventListeners) {
            listener.assetRequested(key);
        }
        AssetCache cache = this.handler.getCache(key.getCacheType());
        AssetProcessor proc = this.handler.getProcessor(key.getProcessorType());
        Object object = obj = cache != null ? (Object)cache.getFromCache(key) : null;
        if (obj == null) {
            AssetLoader loader = this.handler.aquireLoader(key);
            AssetInfo info = this.handler.tryLocate(key);
            if (info == null) {
                if (this.handler.getParentKey() != null) {
                    for (AssetEventListener listener : this.eventListeners) {
                        listener.assetDependencyNotFound(this.handler.getParentKey(), key);
                    }
                }
                throw new AssetNotFoundException(key.toString());
            }
            try {
                this.handler.establishParentKey(key);
                obj = loader.load(info);
            }
            catch (IOException ex) {
                throw new AssetLoadException("An exception has occured while loading asset: " + key, ex);
            }
            finally {
                this.handler.releaseParentKey(key);
            }
            if (obj == null) {
                throw new AssetLoadException("Error occured while loading asset \"" + key + "\" using " + loader.getClass().getSimpleName());
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Loaded {0} with {1}", new Object[]{key, loader.getClass().getSimpleName()});
            }
            if (proc != null) {
                obj = proc.postProcess(key, obj);
            }
            if (cache != null) {
                cache.addToCache(key, obj);
            }
            for (AssetEventListener listener : this.eventListeners) {
                listener.assetLoaded(key);
            }
        }
        if ((clone = obj) instanceof CloneableSmartAsset) {
            if (proc == null) {
                throw new IllegalStateException("Asset implements CloneableSmartAsset but doesn't have processor to handle cloning");
            }
            clone = proc.createClone(obj);
            if (cache != null && clone != obj) {
                cache.registerAssetClone(key, clone);
            } else {
                throw new IllegalStateException("Asset implements CloneableSmartAsset but doesn't have cache or was not cloned");
            }
        }
        return (T)clone;
    }

    @Override
    public Object loadAsset(String name) {
        return this.loadAsset(new AssetKey(name));
    }

    @Override
    public Texture loadTexture(TextureKey key) {
        return this.loadAsset(key);
    }

    @Override
    public Material loadMaterial(String name) {
        return this.loadAsset(new MaterialKey(name));
    }

    @Override
    public Texture loadTexture(String name) {
        TextureKey key = new TextureKey(name, true);
        key.setGenerateMips(true);
        Texture tex = this.loadTexture(key);
        logger.log(Level.FINE, "{0} - {1}", new Object[]{tex, tex.getMinFilter()});
        return tex;
    }

    @Override
    public AudioData loadAudio(AudioKey key) {
        return this.loadAsset(key);
    }

    @Override
    public AudioData loadAudio(String name) {
        return this.loadAudio(new AudioKey(name, false));
    }

    @Override
    public BitmapFont loadFont(String name) {
        return (BitmapFont)this.loadAsset(new AssetKey(name));
    }

    @Override
    public Spatial loadModel(ModelKey key) {
        return this.loadAsset(key);
    }

    @Override
    public Spatial loadModel(String name) {
        return this.loadModel(new ModelKey(name));
    }

    @Override
    public Shader loadShader(ShaderKey key) {
        SimpleAssetCache cache = this.handler.getCache(SimpleAssetCache.class);
        Shader shader = cache.getFromCache(key);
        if (shader == null) {
            String vertName = key.getVertName();
            String fragName = key.getFragName();
            String vertSource = (String)this.loadAsset(new AssetKey(vertName));
            String fragSource = (String)this.loadAsset(new AssetKey(fragName));
            shader = new Shader();
            shader.initialize();
            shader.addSource(Shader.ShaderType.Vertex, vertName, vertSource, key.getDefines().getCompiled(), key.getVertexShaderLanguage());
            shader.addSource(Shader.ShaderType.Fragment, fragName, fragSource, key.getDefines().getCompiled(), key.getFragmentShaderLanguage());
            cache.addToCache(key, shader);
        }
        return shader;
    }
}

